ac.debug('name','traffic_lights')
local time_mcdo = 30
local wait_mcdo = time_mcdo
local time_tunel = 30
local wait_tunel = time_tunel
local time_village = 30
local wait_village = time_village
local time_shell = 30
local wait_shell = time_shell
local DT = 0

--mcdo_traffic_lights
local TL3_r = ac.findMeshes("TRAFFIC_LIGHTS_16")
local TL3_y = ac.findMeshes("TRAFFIC_LIGHTS_15")
local TL3_g = ac.findMeshes("TRAFFIC_LIGHTS_17")
local TL4_r = ac.findMeshes("TRAFFIC_LIGHTS_12")
local TL4_y = ac.findMeshes("TRAFFIC_LIGHTS_14")
local TL4_g = ac.findMeshes("TRAFFIC_LIGHTS_13")
local TL_3_status = true
local TL_4_status = false

--tunel_traffic_lights
local TL1_r = ac.findMeshes("TRAFFIC_LIGHTS_23")
local TL1_y = ac.findMeshes("TRAFFIC_LIGHTS_21")
local TL1_g = ac.findMeshes("TRAFFIC_LIGHTS_25")
local TL2_r = ac.findMeshes("TRAFFIC_LIGHTS_22")
local TL2_y = ac.findMeshes("TRAFFIC_LIGHTS_20")
local TL2_g = ac.findMeshes("TRAFFIC_LIGHTS_24")
local TL_1_status = true
local TL_2_status = true

--village_traffic_lights
local TLv_r = ac.findMeshes("TRAFFIC_LIGHTS_30")
local TLv_y = ac.findMeshes("TRAFFIC_LIGHTS_33")
local TLv_g = ac.findMeshes("TRAFFIC_LIGHTS_29")
local TLv_status = true

--shell_traffic_lights
local TL5_r = ac.findMeshes("TRAFFIC_LIGHTS_02")
local TL5_y = ac.findMeshes("TRAFFIC_LIGHTS_00")
local TL5_g = ac.findMeshes("TRAFFIC_LIGHTS_04")
local TL6_r = ac.findMeshes("TRAFFIC_LIGHTS_08")
local TL6_y = ac.findMeshes("TRAFFIC_LIGHTS_06")
local TL6_g = ac.findMeshes("TRAFFIC_LIGHTS_09")
local TL_5_status = true
local TL_6_status = true

function update(dt)

    DT = dt
    mcdo_traffic_lights()
    tunel_traffic_lights()
    village_traffic_lights()
    shell_traffic_lights()

end

function mcdo_traffic_lights()

    ac.debug('wait_mcdo',wait_mcdo)
    
    if TL_3_status == true and TL_4_status == false then
        ac.debug('status_mcdo','feu 3')

        if wait_mcdo >= 5  then
            TL3_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL3_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL3_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 10 )
            TL4_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 10 )
            TL4_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        else
            TL3_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL3_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 10 )
            TL3_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 10 )
            TL4_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 10 )
            TL4_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_mcdo > 0 then
            wait_mcdo = wait_mcdo - DT
        else
            mcdo_traffic_lights_change()
        end
    else 
        ac.debug('status_mcdo','feu 4')

        if wait_mcdo >= 5 then
            TL3_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 10 )
            TL3_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL3_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 10 )
        else
            TL3_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 10 )
            TL3_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 10 )
            TL3_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL4_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 10 )
            TL4_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_mcdo > 0 then
            wait_mcdo = wait_mcdo - DT
        else
            mcdo_traffic_lights_change()
        end
    end

end

function mcdo_traffic_lights_change()

    TL_3_status = not TL_3_status
    TL_4_status = not TL_4_status
    wait_mcdo = time_mcdo

end

function tunel_traffic_lights()

    ac.debug('wait_tunel',wait_tunel)
    ac.debug('TL_1_status',TL_1_status)
    ac.debug('TL_2_status',TL_2_status)
    
    if TL_1_status == true and TL_2_status == true then
        ac.debug('status_tunel','vert')

        if wait_tunel >= 5  then
            TL1_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL1_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL1_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 2 )
            TL2_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 2 )
        else
            TL1_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL1_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL1_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL2_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_tunel > 0 then
            wait_tunel = wait_tunel - DT
        else
            tunel_traffic_lights_change()
        end
    else 
        ac.debug('status_tunel','rouge')

        if wait_tunel >= 5 then
            TL1_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2)
            TL1_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL1_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL2_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        else
            TL1_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL1_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2)
            TL1_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL2_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL2_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL2_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_tunel > 0 then
            wait_tunel = wait_tunel - DT
        else
            tunel_traffic_lights_change()
        end
    end

end

function tunel_traffic_lights_change()

    TL_1_status = not TL_1_status
    TL_2_status = not TL_2_status
    wait_tunel = time_tunel

end

function village_traffic_lights()

    ac.debug('wait_village',wait_village)
    ac.debug('TLv_status',TLv_status)
    
    if TLv_status == true then
        ac.debug('status_village','vert')

        if wait_village >= 5  then
            TLv_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TLv_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TLv_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 2 )
        else
            TLv_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TLv_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TLv_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_village > 0 then
            wait_village = wait_village - DT
        else
            village_traffic_lights_change()
        end
    else 
        ac.debug('status_village','rouge')

        if wait_village >= 5 then
            TLv_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TLv_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TLv_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        else
            TLv_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TLv_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TLv_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_village > 0 then
            wait_village = wait_village - (4*DT)
        else
            village_traffic_lights_change()
        end
    end

end

function village_traffic_lights_change()

    TLv_status = not TLv_status
    wait_village = time_village

end

function shell_traffic_lights()

    ac.debug('wait_shell',wait_shell)
    ac.debug('TL_5_status',TL_5_status)
    ac.debug('TL_6_status',TL_6_status)
    
    if TL_5_status == true and TL_6_status == true then
        ac.debug('status_shell','vert')

        if wait_tunel >= 5  then
            TL5_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL5_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL5_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 2 )
            TL6_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_g:setMaterialProperty('ksEmissive', rgb(0, 100, 0) * 2 )
        else
            TL5_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL5_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL5_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_r:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL6_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_shell > 0 then
            wait_shell = wait_shell - DT
        else
            sheel_traffic_lights_change()
        end
    else 
        ac.debug('status_shell','rouge')

        if wait_shell >= 5 then
            TL5_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL5_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL5_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL6_y:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        else
            TL5_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL5_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL5_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
            TL6_r:setMaterialProperty('ksEmissive', rgb(100, 0, 0) * 2 )
            TL6_y:setMaterialProperty('ksEmissive', rgb(100, 75, 0) * 2 )
            TL6_g:setMaterialProperty('ksEmissive', rgb(1, 1, 1) * 0 )
        end

        if wait_shell > 0 then
            wait_shell = wait_shell - (3.5*DT)
        else
            sheel_traffic_lights_change()
        end
    end

end

function sheel_traffic_lights_change()

    TL_5_status = not TL_5_status
    TL_6_status = not TL_6_status
    wait_shell = time_shell

end