local menu= true
local currentscreen = "MENU"
local blk = true
local screenSize = vec2(1508, 1209)
local colorWhite = rgbm(1, 1, 1, 1)
local colorHover = rgbm(0.2, 0.2, 0.2, 1)
local roadmode = false
local extconfig
ac.store(roadmod, 0)

--ac.INIConfig:set('LIGHT_EXTRA_1', 'COLOR', rgbm(500,50,50,0.8))


local radio = {
  player = ui.MediaPlayer(),
  --tuningPlayer = ui.MediaPlayer(),
  station = nil,
  volume = 0.10,
  state = 0
}

radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
--radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
local player = ui.MediaPlayer()

local stations = {
  {
    title = "Radio 1",
    thumbnail = "https://static.mytuner.mobi/media/tvos_radios/BFcU2vjUXh.png",
    streamURL = "https://stream.live.vc.bbcmedia.co.uk/bbc_radio_one"
  },
  {
    title = "1Xtra",
    thumbnail = "https://d3g9pb5nvr3u7.cloudfront.net/sites/55b69abe2f8b388f2259f584/680476642/256.png",
    streamURL = "http://stream.live.vc.bbcmedia.co.uk/bbc_1xtra"
  },
  {
    title = "Elusive.fm",
    thumbnail = "https://elusive.fm/wp/wp-content/uploads/2021/10/elusive-logo.jpg",
    streamURL = "http://solid2.streamupsolutions.com:24953/stream"
  },
  {
    title = "Country",
    thumbnail = "http://cdn-profiles.tunein.com/s249981/images/logod.jpg?t=637601529320000000",
    streamURL = "http://205.164.62.22:7806|1.FM - Classic Country|Country|EN|128|0"
  },
  {
    title = "Dr Chill ",
    thumbnail = "https://seeded-session-images.scdn.co/v1/img/artist/02sp94ivWaP4d19xhQvIXC/en",
    streamURL = "http://sc2.dubplate.fm:5000/DnB/192"
  },
  {
    title = "Dubplate",
    thumbnail = "https://www.radio.net/images/broadcasts/68/76/16727/c300.png",
    streamURL = "http://sc2.dubplate.fm:5000/Electro/192"
  }
}

radio.station = stations[4]

function update(dt)

  --menu
  --ui.drawQuad(vec2(95, 5), vec2(290, 5), vec2(290, 22), vec2(95, 22), rgbm(1, 0, 0, 1))
  display.rect { -- just draw a simple rect for each bit in series
      pos = vec2(95,5), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
      size = vec2(195,17),
      color = rgbm(0.1, 0.1, 0.1, 1)
  }
  display.text({
    text = "Main menu",
    pos = vec2(110,2),
    letter = vec2(12.5 * 1.5, 25 * 1),
    font = 'sls',
    color = colorWhite,
    width = 10,
    alignment = 0
  })
  if ui.rectHovered(vec2(95, 5), vec2(290, 22)) then
    if ui.mouseClicked() then
      menu = true
    end
  end

  if menu == true then
    ac.setDynamicTextureShift("NAVIGATOR_0", 0)
    ac.setDynamicTextureShift("CAR_STEREO_0", 0)
    ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)
    ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
    currentscreen = "MENU"

    menubackground()

    --nav button
    --ui.drawQuad(vec2(157, 48), vec2(410, 48), vec2(410, 126), vec2(157, 126), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(157, 48), vec2(410, 126)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "NAVIGATOR_0"
          nav()
        return  -- and we're done here, so let's stop
      end
    end

    --media
    --ui.drawQuad(vec2(427, 47), vec2(680, 47), vec2(680, 125), vec2(427, 125), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(427, 47), vec2(680, 125)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "CAR_STEREO_0"
          media()
        return  -- and we're done here, so let's stop
      end
    end

    --radio
    --ui.drawQuad(vec2(687, 47), vec2(937, 47), vec2(937, 125), vec2(687, 125), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(687, 47), vec2(937, 125)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "RADIO"
        DisplayRadioPage()
        return  -- and we're done here, so let's stop
      end
    end

    --extra
    --ui.drawQuad(vec2(150, 130), vec2(400, 130), vec2(400, 209), vec2(150, 209), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(150, 130), vec2(400, 209)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "EXTRA"
        extra()
        return  -- and we're done here, so let's stop
      end
    end

    --susp
    --ui.drawQuad(vec2(417, 129), vec2(670, 129), vec2(670, 208), vec2(417, 208), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(417, 129), vec2(670, 208)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "SUSP"
        susp()
        return  -- and we're done here, so let's stop
      end
    end

    --reverse camera
    --ui.drawQuad(vec2(677, 129), vec2(930, 129), vec2(930, 208), vec2(677, 208), rgbm(1, 0, 0, 1))
    if ui.rectHovered(vec2(677, 129), vec2(930, 208)) then
      if ui.mouseClicked() then
        menu = false
        currentscreen = "REVERSE"
          reversecam()
        return  -- and we're done here, so let's stop
      end
    end

  end

  if car.gear ~= -1 then
    -- If gear is not reverse, activate navigator:
    while blk == true do
      display.rect { -- just draw a simple rect for each bit in series
      pos = vec2(75,-45), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
      size = vec2(1520.4,413.1),
      color = rgbm(0, 0, 0, 1)
      }
      blk = false
    end
    if currentscreen == "NAVIGATOR_0" or currentscreen == "CAR_STEREO_0" then
      ac.setDynamicTextureShift(currentscreen, 1)
      ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)  -- pause rendering camera
      ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
    elseif currentscreen == "RADIO" then
      DisplayRadioPage()
      ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)  -- pause rendering camera
      ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
    elseif currentscreen == "EXTRA" then
      extra()
      ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)  -- pause rendering camera
      ac.setRenderingCameraActive("RENDERING_CAMERA_1", true)
    elseif currentscreen == "SUSP" then
      susp()
      ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)  -- pause rendering camera
      ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
    elseif currentscreen == "REVERSE" then
      reversecam()
      ac.setRenderingCameraActive("RENDERING_CAMERA_0", true)
      ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
    end

    
    return  -- and we’re done here, so let’s stop
  end

  blk = true
  reversecam()

end


function menubackground()
    display.rect { -- just draw a simple rect for each bit in series
    pos = vec2(75,-45), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
    size = vec2(1520.4,413.1),
    color = rgbm(0, 0, 0, 1)
    }

    display.image({
    image = "assets/Console.dds",
    pos = vec2(100,-75),
    size = vec2(1520.4,413.1),
    color = rgbm(1, 1, 1, 1)
    })
end

function nav()
  ac.setDynamicTextureShift("NAVIGATOR_0", 1)  -- this function sets its opacity, it can do more
  -- ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)  -- pause rendering camera
end

function media()
  ac.setDynamicTextureShift("CAR_STEREO_0", 1)
end

function reversecam()
        ac.setDynamicTextureShift("NAVIGATOR_0", 0)  -- let's stop navigator
        ac.setDynamicTextureShift("CAR_STEREO_0", 0)
        ac.setRenderingCameraActive("RENDERING_CAMERA_1", false)
        ac.setRenderingCameraActive("RENDERING_CAMERA_0", true)  -- activate rendering camera
        display.image{pos = vec2(0, 22), size = vec2(1040, 460), image = "dynamic::camera_rear_distorted"}  -- and draw fisheye camera

        -- Gear is reverse!

        -- And we're done! But for a bit of extra authenticity let's add lines with trajectory:
        local startL = vec2(280, 230)  -- one thing to note: I haven't really properly calibrated those lines yet
        local startR = vec2(805- 40, 230)
        local direction = vec2(27.5, -23.0):normalize()
        local lineLen = 200
        local steps = 10
        local steerOffset = -car.steer * 0.20
        local currentPosL = startL
        local currentPosR = startR
        local color = rgbm(0, 0, 0, 0)
        for i = 1, steps do
          local newPosL = startL + direction * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
          local newPosR = startR + vec2(-direction.x, direction.y) * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
          local drawAcrossColor = color
          if i == 3 then
            color = rgbm(0, 1, 0, 0)
          elseif i == 6 then
            color = rgbm(0, 1, 0, 0)
          else
            drawAcrossColor = i == 9 and color or nil
          end
          ui.drawLine(currentPosL, newPosL, color, 5)
          ui.drawLine(currentPosR, newPosR, color, 5)
          if drawAcrossColor ~= nil then
            ui.drawLine(currentPosL, currentPosR, drawAcrossColor, 4)
          end
          currentPosL = newPosL
          currentPosR = newPosR
          direction:add(vec2(0.0005, 0.0010)):normalize()
        end

        -- And a warning:
        display.rect{pos = vec2(40, 276), size = vec2(396, 32), color = rgbm(0, 0, 0, 0.0 )}
        display.text{pos = vec2(40, 286), letter = vec2(12, 20), text = "", font = "aria", width = 396, alignment = 0.5 }
end

function DisplayRadioPage()
  setWallpaper()
  DisplayVolumeBars(vec2(650,125), radio.volume * 10, LowerRadioVolume, RaiseRadioVolume)
  DisplayRadioCountryList()
  DisplayCurrentRadioStation(radio.station.thumbnail, radio.station.title)
  DisplayRadioButtons()
  Numstation ()
end

function DisplayVolumeBars(pos, value, LowerFunction, RaiseFuction)
  local offset = vec2(15, 0)
  local color
  for i = 1, 10 do
      if (value > i) then
          color = rgbm(1, 1, 1, 1)
      else
          color = rgbm(0.1, 0.1, 0.1, 1)
      end
      display.rect { -- just draw a simple rect for each bit in series
          pos = pos + offset * (i - 1), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
          size = vec2(10, 25),
          color = color
      }
  end

  ui.drawImage("./icons/plus.png", pos + offset * (10.5) + vec2(0, 0), -- ./icons/play.png
  pos + offset * (10 - 1) + vec2(60, 0) + 25, colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(pos + offset * (10.5) + vec2(0, 0), pos + offset * (10 - 1) + vec2(60, 0) + 25) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/plus.png", pos + offset * (10.5) + vec2(0, 0),
          pos + offset * (10 - 1) + vec2(60, 0) + 25, colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
          RaiseFuction()
      end
  end

  ui.drawImage("./icons/minus.png", pos + vec2(-65, 0), -- ./icons/play.png
  pos + vec2(-40, 0) + 25, colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(pos + vec2(-65, 0), pos + vec2(-40, 0) + 25) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/minus.png", pos + vec2(-65, 0), pos + vec2(-40, 0) + 25, colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
          LowerFunction()
      end
  end

end

function RaiseRadioVolume()
  if (radio.volume < 1.0) then
      radio.volume = radio.volume + 0.1
      radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
      --radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
  end
end

function LowerRadioVolume()
  if (radio.volume > 0.1) then
      radio.volume = radio.volume - 0.1
      radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
      --radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
  end
end

function DisplayRadioCountryList()

  local posy = 0.2
  local posx = -1
  for i = 1, #stations do
      posx = posx + 1
      if i > 6 then
          break
          if (posx > 4) then
              posx = 0
          end
          posy = 0
      end
      createHomeMenuButton(stations, rgbm(0.1, 0.1, 0.1, 0), posx, posy, "" -- stations[i].title
      , function ()
          radio.station = stations[i]
          PlayRadioStation(stations[i].streamURL)
          radio.state = true
      end, stations[i].title, stations[i].thumbnail, vec2(150, 140), vec2(0, 440))
  end
end

function createHomeMenuButton(text, color, positionX, positionY, state, method, on, image, p1, p2)
  local hoverColor = rgbm(0.4, 0.4, 0.4, 1)
  local buttonDistanceX = 25
  local buttonDistanceY = 50
  local padding = 10
  local paddingText = 5
  local size = (p2 - p1) / 3
  size = vec2(size.y, size.y-50)

  local newp1 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                    vec2(buttonDistanceX * positionX, buttonDistanceY * positionY)
  local newp2 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                    vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) + vec2(size.x, size.y)
  if image ~= nil then
      ui.drawImage(image, newp1, newp2) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
  end
  local textLocation = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                           vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) +
                           vec2(-size.x / 2, size.y + paddingText)
  display.text {
      text = state,
      pos = textLocation,
      color = colorWhite,
      letter = vec2(10, 25),
      font = "sls",
      width = 200,
      alignment = 0.5
  }
  if ui.rectHovered(newp1, newp2 + vec2(0, 30)) then
      -- ui.drawRect(newp1, newp2, hoverColor, 10, 15, 1.5)
      if image ~= nil then
          ui.drawImage(image, newp1, newp2, hoverColor) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
      end
      if ui.mouseClicked() then
          method()
      end
  end
end


function PlayRadioStation(radioStationStream)
  radio.player:setSource(radioStationStream)
  radio.player:play()
end

function DisplayCurrentRadioStation(stationImage, stationTitle)
  ui.drawImage(stationImage, vec2(150, 30), vec2(screenSize.x / 3.5, screenSize.y / 11.5 ), false)
  display.text({
      text = stationTitle,
      pos = vec2(600,30),
      letter = vec2(25 * 1.5, 35 * 1),
      font = 'aria',
      color = colorWhite,
      width = 250,
      alignment = 0.5
  })
end

function DisplayRadioButtons()

  if (radio.player:playing()) then
      ui.drawImage("./icons/power.png", vec2(265, 125), vec2(305, 145), rgbm(1, 0, 0, 1))
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
      -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
      if ui.rectHovered(vec2(265, 125), vec2(305, 145)) then
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
          ui.drawImage("./icons/power.png", vec2(265, 125), vec2(305, 145),
          rgbm(0.2, 0, 0, 1))
          -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
          if ui.mouseClicked() then
              radio.player:pause()
              radio.state = false
          end
      end
      ac.setExtraSwitch(2, true)
  else
      ui.drawImage("./icons/power.png", vec2(265, 125), vec2(305, 145), colorWhite)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
      -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
      if ui.rectHovered(vec2(265, 125), vec2(305, 145)) then
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
          ui.drawImage("./icons/power.png", vec2(265, 125), vec2(305, 145), colorHover)
          -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
          if ui.mouseClicked() then
              radio.player:play()
              radio.state = true
          end
      end
      ac.setExtraSwitch(2, false)
  end

  ui.drawImage("./icons/next.png", vec2(235, 125), vec2(195, 145), colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(vec2(195, 125), vec2(235, 145)) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/next.png", vec2(235, 125), vec2(195, 145), colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
        Prevstation()
          -- currentScreen = previousScreen[1]
          -- table.remove(previousScreen, 1)
          -- ui.toast(ui.Icons.Apps, ac.getCameraPosition())
      end
  end

  ui.drawImage("./icons/next.png", vec2(335, 125), vec2(375, 145), colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(vec2(335, 125), vec2(375, 145)) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/next.png", vec2(335, 125), vec2(375, 145), colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
        Nextstation()
          -- currentScreen = previousScreen[1]
          -- table.remove(previousScreen, 1)
          -- ui.toast(ui.Icons.Apps, ac.getCameraPosition())
      end
    end
end

function setWallpaper()

  display.rect { -- just draw a simple rect for each bit in series
      pos = vec2(0,22), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
      size = vec2(1520.4,413.1),
      color = rgbm(0, 0, 0, 1)
  }

  display.image({
      image = "assets/black.dds",
      pos = vec2(0,22),
      size = vec2(1520.4,413.1),
      color = rgbm(1, 1, 1, 1)
  })

end

function Numstation ()
  local stationnum = 0
  for i = 1, #stations, 1 do
    if radio.station.title == stations[i].title then
      stationnum = i
    end
  end

  function Prevstation()
    if stationnum > 1 then
      stationnum = stationnum - 1
      radio.station = stations[stationnum]
      PlayRadioStation(stations[stationnum].streamURL)
      radio.state = true
    end
  end

  function Nextstation()
    if stationnum < #stations then
      stationnum = stationnum + 1
      radio.station = stations[stationnum]
      PlayRadioStation(stations[stationnum].streamURL)
      radio.state = true
    end
  end
end

function extra()
  ac.setDynamicTextureShift("NAVIGATOR_0", 0)  -- let's stop navigator
  ac.setDynamicTextureShift("CAR_STEREO_0", 0)
  ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)
  ac.setRenderingCameraActive("RENDERING_CAMERA_1", true)  -- activate rendering camera
  display.image{pos = vec2(0, 22), size = vec2(1024,345), image = "dynamic::camera_top_distorted"}  -- and draw fisheye camera
  extraSettings()
end


function extraSettings()

  local settings = {{
      text = "Extra A",
      stateText = function()
          if (ac.getCar().extraA == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraA,
      method = function()
          ac.setExtraSwitch(0, not ac.getCar().extraA)
      end
  }, {
      text = "Extra B",
      stateText = function()
          if (ac.getCar().extraB == true) then
            return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraB,
      method = function()
          ac.setExtraSwitch(1, not ac.getCar().extraB)
      end
  }, {
      text = "Extra C",
      stateText = function()
          if (ac.getCar().extraC == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraC,
      method = function()
          ac.setExtraSwitch(2, not ac.getCar().extraC)
      end
  }}
  local posy = 0
  local posx = -1
  for i = 1, #settings do
      local setting = settings[i].text
      posx = posx + 1
      if i > 3 then
          if (posx > 2) then
              posx = 0
          end
          posy = 1
      end
      createSettingButton(setting, rgbm(0.1, 0.1, 0.1, 1), posx, posy, settings[i].stateText(), settings[i].method,
          settings[i].state)
  end
end

function createSettingButton(text, color, positionX, positionY, state, method, on, image)
    local offColor = rgbm(1, 1, 1, 1)
    local onColor = rgbm(1, 0.1, 0, 1)


  if (on) then
      color = onColor
  else
      color = offColor
  end

  if text == "Extra A" then
    ui.drawCircle(vec2(300, 190), 10, color, 25, 10)
    

    if ui.rectHovered(vec2(290,180), vec2(310,200)) then
      ui.drawCircle(vec2(300, 190), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
        method()
      end
    end
  end

  if text == "Extra B" then
    ui.drawCircle(vec2(724, 190), 10, color, 25, 10)

    if ui.rectHovered(vec2(714,180), vec2(734,200)) then
      ui.drawCircle(vec2(724, 190), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
        method()
      end
    end
  end

  if text == "Extra C" then
    ui.drawCircle(vec2(512, 240), 10, color, 25, 10)

    if ui.rectHovered(vec2(502,230), vec2(522,250)) then
      ui.drawCircle(vec2(512, 240), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
          method()
      end
    end
  end

end

function susp()

  display.rect { -- just draw a simple rect for each bit in series
    pos = vec2(0,22), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
    size = vec2(1520.4,413.1),
    color = rgbm(0, 0, 0, 1)
  }

  display.text({
      text = "Track mode",
      pos = vec2(200,100),
      letter = vec2(15 * 1.5, 25 * 1),
      font = 'sls',
      color = colorWhite,
      width = 10,
      alignment = 0.5
  })

  display.text({
    text = "Road mode",
    pos = vec2(600,100),
    letter = vec2(15 * 1.5, 25 * 1),
    font = 'sls',
    color = colorWhite,
    width = 10,
    alignment = 0.5
  })

  if roadmode == true then

    ui.drawImage("./icons/swith_on.png", vec2(475, 100), vec2(555, 125), colorWhite)

    if ui.rectHovered(vec2(475, 100), vec2(555, 125)) then

        ui.drawImage("./icons/swith_on.png", vec2(475, 100), vec2(555, 125), colorHover)

        if ui.mouseClicked() then
          local switch = 0
          while switch == 0 do
            ui.drawImage("./icons/swith_mid.png", vec2(475, 100), vec2(555, 125), colorWhite)
            switch =1
            roadmode = false
            ac.store(roadmod, 0)
          end
          return
        end
    end
  return
else
    ui.drawImage("./icons/swith_off.png", vec2(475, 100), vec2(555, 125), colorWhite)

    if ui.rectHovered(vec2(475, 100), vec2(555, 125)) then

        ui.drawImage("./icons/swith_off.png", vec2(475, 100), vec2(555, 125), colorHover)

        if ui.mouseClicked() then
          local switch = 0
          while switch == 0 do
            ui.drawImage("./icons/swith_mid.png", vec2(555, 100), vec2(475, 125), colorWhite)
            switch =1
            roadmode = true
            ac.store(roadmod, 1)
          end
        end
    end
  end
end