local fuelConsumption = 0.00050 -- Fetch this from car.ini/[FUEL] section (couldn't figure out ac.readDataFile())
local currentLitersAvailable = car.fuel
local maxMiles = 440.96 -- Maximum range for the car to drive with a full tank (in miles) 
local bg = "SUB_CLUSTER_DIFF.dds"

function RenderBG()
  display.image{ image = bg, pos = vec2(0,0), size = vec2(1024,1024), uvStart = vec2(0,0), uvEnd = vec2(1, 1) }
end

currentLiters100 = (car.rpm * car.gas * fuelConsumption)/1000 --Fuel consumption. In one second the consumption is (rpm*gas*CONSUMPTION)/1000 litres
currentLitersAvailable = car.fuel - currentLiters100 --Current liters available in the tank
currentRange = math.max(0,currentLitersAvailable * maxMiles/90) --Current mileage range


function update(dt)

    display.text{
        text = math.round(currentRange),
        pos = vec2(512, 620),
        letter = vec2(50,130),
        font = "e92_mid",
        color = rgbm(1,1,1,1),
        alignment = 0,
        width = 200,
        spacing = -3
    }

    display.text{
        text = "km",
        pos = vec2(670, 620),
        letter = vec2(50, 130),
        font = "e92_mid",
        color = rgbm(1,1,1,1), 
        width = 0.5,
        spacing = 10,
        alignment = -1.0
      }

    display.image {
        image = "gas_icon.png",
        pos = vec2(350, 620),
        size = vec2(100, 100),
        uvStart = vec2(0, 0),
        uvEnd = vec2(1, 1)
    }
    
    display.image {
        image = "arrow_white.png",
        pos = vec2(280, 640),
        size = vec2(70, 50),
        uvStart = vec2(0, 0),
        uvEnd = vec2(1, 1)
    }
    
    display.image {
        image = "boarder.png",
        pos = vec2(36, 32),
        size = vec2(261, 180),
        uvStart = vec2(0, 0),
        uvEnd = vec2(1, 1)
    } 
  
    display.text{
      text = string.format("%05.0f", car.distanceDrivenTotalKm),
      pos = vec2(70, 900),
      letter = vec2(50, 130),
      font = "e92_mid",
      color = rgbm(1,1,1,1), 
      width = 0.5,
      spacing = 0,
      alignment = -1.0
    }

    display.text{
      text = string.format("%05.1f", car.distanceDrivenSessionKm),
      pos = vec2(710, 900),
      letter = vec2(50, 130),
      font = "e92_mid",
      color = rgbm(1,1,1,1), 
      width = 0.5,
      spacing = -3,
      alignment = -1.0
    }

    display.rect{  
      pos = vec2(90, 880),
      size = vec2(700 , 10),
      color = rgbm(1,0.3,0,10),
    }

    display.text{
      text = "km",
      pos = vec2(815 , 805),
      letter = vec2(50, 130),
      font = "e92_mid",
      color = rgbm(1,0.3,0,10), 
      width = 0.5,
      spacing = 10,
      alignment = -1.0
    }
    
    local temperature = ac.getSimState().ambientTemperature
    
    display.text{
      text = string.format("%+02.1f C", temperature),
      pos = vec2(310, 388),
      letter = vec2(55, 150),
      font = "e92_mid",
      color = rgbm(1,1,1,1),  
    }
  
    display.text{ 
      text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
      pos = vec2(620, 70),
      letter = vec2(65, 150),
      font = "e92_mid",
      color = rgbm(1,1,1,1)  
    }

    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
	
    display.text {
        text = gearText,
        pos = vec2(130, 55),
        letter = vec2(70, 170),
        color = rgbm(1,1,1,1),
        font = "e92_mid",
        width = 0.5,
        alignment = 0,
        spacing = -1.0
    }

end